<?php

namespace App\Http\Controllers\Guru;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Guru;

class GuruAuthController extends Controller
{
    public function showLoginForm()
    {
        return view('auth.guru_login');
    }

    public function login(Request $request)
    {
        $guru = Guru::where('email', $request->email)
                    ->where('password', $request->password) // plaintext
                    ->first();

        if ($guru) {
            session(['guru_id' => $guru->id]);
            return redirect()->route('guru.dashboard');
        }

        return redirect()->back()->with('error', 'Email atau password salah');
    }

    public function logout()
    {
        session()->forget('guru_id');
        return redirect()->route('guru.login');
    }
}
