<?php
namespace App\Http\Controllers\Guru;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\InventarisGuru;

class GuruInventarisController extends Controller
{
    public function index()
    {
        // ✅ TAMBAH: Session check
        if (!session('guru_id')) return redirect()->route('login');
        
        // ✅ PERBAIKI: Filter by guru_id
        $inventaris = InventarisGuru::where('id_guru', session('guru_id'))->get();
        return view('guru.inventaris.index', compact('inventaris'));
    }

    public function create()
    {
        if (!session('guru_id')) return redirect()->route('login');
        return view('guru.inventaris.create');
    }

    public function store(Request $request)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        InventarisGuru::create([
            'id_guru' => session('guru_id'),
            'kode_barang' => $request->kode_barang,
            'nama_barang' => $request->nama_barang,
            'jumlah' => $request->jumlah,
            'kondisi' => $request->kondisi,
            'lokasi' => $request->lokasi,
            'keterangan' => $request->keterangan,
            'sync_sarpras' => 0
        ]);

        return redirect()->route('guru.inventaris.index')->with('success', 'Inventaris berhasil ditambahkan');
    }
    
    // ✅ TAMBAH: Edit method
    public function edit($id)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        $inventaris = InventarisGuru::where('id_guru', session('guru_id'))
            ->findOrFail($id);
        return view('guru.inventaris.edit', compact('inventaris'));
    }
    
    // ✅ TAMBAH: Update method
    public function update(Request $request, $id)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        $inventaris = InventarisGuru::where('id_guru', session('guru_id'))
            ->findOrFail($id);
        $inventaris->update($request->all());
        
        return redirect()->route('guru.inventaris.index')->with('success', 'Inventaris berhasil diperbarui');
    }
    
    // ✅ TAMBAH: Delete method
    public function destroy($id)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        InventarisGuru::where('id_guru', session('guru_id'))
            ->findOrFail($id)
            ->delete();
            
        return back()->with('success', 'Inventaris berhasil dihapus');
    }
}