<?php
namespace App\Http\Controllers\Guru;
use App\Http\Controllers\Controller;
use App\Models\PeminjamanAlat;

class GuruPeminjamanController extends Controller
{
    public function index()
    {
        // ✅ TAMBAH: Session check
        if (!session('guru_id')) return redirect()->route('login');
        
        // ✅ PERBAIKI: Filter by guru_persetujuan
        $peminjaman = PeminjamanAlat::where('id_guru_persetujuan', session('guru_id'))
            ->orWhere('peminjam_id', session('guru_id'))
            ->where('peminjam_role', 'guru')
            ->get();

        return view('guru.peminjaman.index', compact('peminjaman'));
    }

    public function detail($id)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        $peminjaman = PeminjamanAlat::with('detail', 'detail.barang')
            ->findOrFail($id);
        return view('guru.peminjaman.detail', compact('peminjaman'));
    }
    
    // ✅ TAMBAH: Approval methods
    public function approve($id)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        $peminjaman = PeminjamanAlat::where('id_guru_persetujuan', session('guru_id'))
            ->findOrFail($id);
        $peminjaman->update(['status' => 'disetujui']);
        
        return back()->with('success', 'Peminjaman disetujui');
    }
    
    public function reject($id)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        $peminjaman = PeminjamanAlat::where('id_guru_persetujuan', session('guru_id'))
            ->findOrFail($id);
        $peminjaman->update(['status' => 'ditolak']);
        
        return back()->with('success', 'Peminjaman ditolak');
    }
}