<?php
namespace App\Http\Controllers\Guru;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PenggunaanBahan;
use App\Models\PenggunaanBahanDetail;
use App\Models\BahanPraktik;
use App\Models\Siswa; // ✅ TAMBAH import

class GuruPenggunaanBahanController extends Controller
{
    public function index()
    {
        // ✅ TAMBAH: Session check
        if (!session('guru_id')) return redirect()->route('login');
        
        // ✅ PERBAIKI: Filter by guru_id
        $penggunaan = PenggunaanBahan::with('siswa')
            ->where('id_guru', session('guru_id'))
            ->get();
        return view('guru.penggunaan_bahan.index', compact('penggunaan'));
    }

    public function create()
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        $bahan = BahanPraktik::all();
        $siswa = Siswa::all(); // ✅ TAMBAH: Untuk pilih siswa
        return view('guru.penggunaan_bahan.create', compact('bahan', 'siswa'));
    }

    public function store(Request $request)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        $penggunaan = PenggunaanBahan::create([
            'kode_penggunaan' => 'GBH-' . time(),
            'id_siswa' => $request->id_siswa,
            'id_guru' => session('guru_id'),
            'tanggal' => $request->tanggal,
            'keterangan' => $request->keterangan
        ]);

        if($request->bahan_id) {
            foreach ($request->bahan_id as $index => $bahanId) {
                PenggunaanBahanDetail::create([
                    'penggunaan_id' => $penggunaan->id,
                    'id_bahan' => $bahanId,
                    'jumlah' => $request->jumlah[$index] ?? 1,
                    'satuan' => $request->satuan[$index] ?? 'pcs',
                    'keterangan' => $request->keterangan_detail[$index] ?? null
                ]);
            }
        }

        return redirect()->route('guru.penggunaan_bahan.index')
                         ->with('success', 'Penggunaan bahan berhasil ditambahkan');
    }
    
    // ✅ TAMBAH: Detail method
    public function detail($id)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        $penggunaan = PenggunaanBahan::with('detail.bahan', 'siswa')
            ->where('id_guru', session('guru_id'))
            ->findOrFail($id);
        return view('guru.penggunaan_bahan.detail', compact('penggunaan'));
    }
}