<?php
namespace App\Http\Controllers\Guru;
use App\Http\Controllers\Controller;
use App\Models\Guru;
use Illuminate\Http\Request;

class GuruProfilController extends Controller
{
    public function index()
    {
        // ✅ TAMBAH: Session check
        if (!session('guru_id')) return redirect()->route('login');
        
        $guru = Guru::find(session('guru_id'));
        return view('guru.profil', compact('guru'));
    }

    public function update(Request $request)
    {
        if (!session('guru_id')) return redirect()->route('login');
        
        $guru = Guru::find(session('guru_id'));
        
        // ✅ PERBAIKI: Hanya update password jika diisi
        $data = $request->only(['nama','email','telepon','jabatan']);
        if ($request->password) {
            $data['password'] = $request->password; // plaintext
        }
        
        $guru->update($data);
        return redirect()->route('guru.profil')->with('success','Profil berhasil diperbarui!');
    }
}