<?php

namespace App\Http\Controllers\Siswa;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Siswa;

class SiswaAuthController extends Controller
{
    public function showLoginForm()
    {
        return view('auth.siswa_login');
    }

    public function login(Request $request)
    {
        $siswa = Siswa::where('email', $request->email)
                      ->where('password', $request->password) // plaintext
                      ->first();

        if ($siswa) {
            session(['siswa_id' => $siswa->id]);
            return redirect()->route('siswa.dashboard');
        }

        return redirect()->back()->with('error', 'Email atau password salah.');
    }

    public function logout()
    {
        session()->forget('siswa_id');
        return redirect()->route('siswa.login');
    }
}
