<?php

namespace App\Http\Controllers\Siswa;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PenggunaanBahan;
use App\Models\PenggunaanBahanDetail;
use App\Models\BahanPraktik;
use App\Models\Guru;

class SiswaPenggunaanBahanController extends Controller
{
    public function index()
    {
        // ✅ TAMBAHKAN: Session check
        if (!session('siswa_id')) {
            return redirect()->route('login')->with('error', 'Silakan login terlebih dahulu.');
        }
        
        $siswa_id = session('siswa_id');
        
        // ✅ PERBAIKI: Hanya ambil data siswa yang login
        $penggunaan = PenggunaanBahan::where('id_siswa', $siswa_id)
            ->orderBy('created_at', 'desc')
            ->get();
            
        return view('siswa.penggunaan_bahan.index', compact('penggunaan'));
    }

    public function create()
    {
        // ✅ TAMBAHKAN: Session check
        if (!session('siswa_id')) {
            return redirect()->route('login');
        }
        
        $bahan = BahanPraktik::where('stok', '>', 0)->get(); // ✅ Hanya bahan tersedia
        $guru = Guru::all(); // ✅ Untuk pilihan pembimbing
        
        return view('siswa.penggunaan_bahan.create', compact('bahan', 'guru'));
    }

    public function store(Request $request)
    {
        // ✅ TAMBAHKAN: Session check
        if (!session('siswa_id')) {
            return redirect()->route('login');
        }
        
        // ✅ VALIDASI sederhana
        if (empty($request->bahan_id)) {
            return back()->with('error', 'Pilih minimal satu bahan.');
        }
        
        // ✅ Buat penggunaan bahan
        $penggunaan = PenggunaanBahan::create([
            'kode_penggunaan' => 'BAHAN-' . date('Ymd') . '-' . rand(1000, 9999),
            'id_siswa' => session('siswa_id'),
            'id_guru' => $request->id_guru ?: null,
            'tanggal' => $request->tanggal,
            'keterangan' => $request->keterangan,
        ]);

        // ✅ Simpan detail penggunaan
        foreach ($request->bahan_id as $index => $bahanId) {
            PenggunaanBahanDetail::create([
                'penggunaan_id' => $penggunaan->id,
                'id_bahan' => $bahanId,
                'jumlah' => $request->jumlah[$index] ?? 1,
                'satuan' => $request->satuan[$index] ?? 'pcs',
                'keterangan' => $request->keterangan_detail[$index] ?? '',
            ]);
            
            // ✅ Kurangi stok bahan (optional)
            $bahan = BahanPraktik::find($bahanId);
            if ($bahan && $bahan->stok > 0) {
                $bahan->decrement('stok', $request->jumlah[$index] ?? 1);
            }
        }

        return redirect()->route('siswa.penggunaan_bahan.index')
            ->with('success', 'Penggunaan bahan berhasil dicatat.');
    }
    
    // ✅ TAMBAHKAN: Method untuk detail
    public function detail($id)
    {
        if (!session('siswa_id')) {
            return redirect()->route('login');
        }
        
        $siswa_id = session('siswa_id');
        
        $penggunaan = PenggunaanBahan::with('detail.bahan', 'guru')
            ->where('id', $id)
            ->where('id_siswa', $siswa_id)
            ->firstOrFail();
            
        return view('siswa.penggunaan_bahan.detail', compact('penggunaan'));
    }
}