<?php

namespace App\Http\Controllers\Siswa;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Siswa;

class SiswaProfilController extends Controller
{
    public function index()
    {
        // ✅ TAMBAHKAN: Session check
        if (!session('siswa_id')) {
            return redirect()->route('login')->with('error', 'Silakan login terlebih dahulu.');
        }
        
        $siswa = Siswa::find(session('siswa_id'));
        return view('siswa.profil', compact('siswa'));
    }

    public function update(Request $request)
    {
        // ✅ TAMBAHKAN: Session check
        if (!session('siswa_id')) {
            return redirect()->route('login');
        }
        
        $siswa = Siswa::find(session('siswa_id'));
        
        // ✅ TAMBAHKAN: Validasi sederhana
        $updateData = [
            'nama' => $request->nama,
            'email' => $request->email,
            'kelas' => $request->kelas,
            'jurusan' => $request->jurusan,
            'telepon' => $request->telepon,
        ];
        
        // ✅ Hanya update password jika diisi
        if (!empty($request->password)) {
            $updateData['password'] = $request->password; // plaintext
        }
        
        $siswa->update($updateData);

        return redirect()->route('siswa.profil')
            ->with('success', 'Profil berhasil diperbarui.');
    }
}