<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AturanPeminjaman extends Model
{
    protected $table = 'aturan_peminjaman';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'nama','deskripsi','maksimal_hari','denda_per_hari',
        'perlu_persetujuan_guru','aktif'
    ];

    public function peminjaman()
    {
        return $this->hasMany(PeminjamanAlat::class, 'aturan_id');
    }

    public function persetujuanSarpras()
    {
        return $this->hasMany(PersetujuanSarpras::class, 'id_aturan');
    }
}
