@extends('layouts.admin')

@section('title', 'Daftar Aturan Peminjaman')

@section('content')
<div class="container-fluid py-4">
    <h3 class="mb-4">Daftar Aturan Peminjaman</h3>

    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-striped table-bordered" id="datatable">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Nama Aturan</th>
                        <th>Deskripsi</th>
                        <th>Maksimal Hari</th>
                        <th>Denda/Hari</th>
                        <th>Perlu Persetujuan Guru</th>
                        <th>Aktif</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($aturan as $a)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $a->nama }}</td>
                        <td>{{ $a->deskripsi }}</td>
                        <td>{{ $a->maksimal_hari }}</td>
                        <td>{{ $a->denda_per_hari }}</td>
                        <td>
                            <span class="badge {{ $a->perlu_persetujuan_guru ? 'bg-success' : 'bg-secondary' }}">
                                {{ $a->perlu_persetujuan_guru ? 'Ya' : 'Tidak' }}
                            </span>
                        </td>
                        <td>
                            <span class="badge {{ $a->aktif ? 'bg-success' : 'bg-danger' }}">
                                {{ $a->aktif ? 'Aktif' : 'Nonaktif' }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('admin.aturan.edit', $a->id) }}" class="btn btn-sm btn-primary">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('#datatable').DataTable({
            "order": [[ 0, "desc" ]]
        });
    });
</script>
@endpush
@endsection
