@extends('layouts.admin')

@section('content')
<div class="container py-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold">Daftar Bahan Praktik</h4>
        <a href="{{ route('admin.bahan.create') }}" class="btn btn-primary btn-sm">
            + Tambah Bahan
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body p-0">
            <table class="table table-bordered table-striped mb-0">
                <thead class="table-dark">
                    <tr>
                        <th width="50">#</th>
                        <th>Kode</th>
                        <th>Nama</th>
                        <th>Stok</th>
                        <th>Satuan</th>
                        <th>Keterangan</th>
                        <th width="120">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($bahan as $i => $b)
                    <tr>
                        <td>{{ $i+1 }}</td>
                        <td>{{ $b->kode }}</td>
                        <td>{{ $b->nama }}</td>
                        <td>{{ $b->stok }}</td>
                        <td>{{ $b->satuan }}</td>
                        <td>{{ $b->keterangan ?? '-' }}</td>
                        <td>
                            <form action="{{ route('admin.bahan.delete', $b->id) }}" method="POST"
                                  onsubmit="return confirm('Hapus bahan ini?')">
                                @csrf
                                @method('DELETE')

                                <button class="btn btn-danger btn-sm">Hapus</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach

                    @if($bahan->count() == 0)
                    <tr>
                        <td colspan="7" class="text-center py-3 text-muted">
                            Tidak ada data bahan praktik.
                        </td>
                    </tr>
                    @endif

                </tbody>
            </table>
        </div>
    </div>

</div>
@endsection
