@extends('layouts.admin')

@section('title', 'Data Guru')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold">Data Guru</h4>
    <a href="{{ route('admin.guru.create') }}" class="btn btn-primary">
        <i class="fa fa-plus me-1"></i> Tambah Guru
    </a>
</div>

<div class="card shadow-sm">
    <div class="card-body">
        <table id="datatable" class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>NIP</th>
                    <th>Nama</th>
                    <th>Email</th>
                    <th>Telepon</th>
                    <th>Jabatan</th>
                    <th>Harus Setujui Sarpras</th>
                    <th width="150">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($guru as $g)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $g->nip }}</td>
                    <td>{{ $g->nama }}</td>
                    <td>{{ $g->email }}</td>
                    <td>{{ $g->telepon }}</td>
                    <td>{{ $g->jabatan }}</td>
                    <td>
                        @if ($g->harus_setujui_sarpras)
                            <span class="badge bg-success">Ya</span>
                        @else
                            <span class="badge bg-secondary">Tidak</span>
                        @endif
                    </td>
                    <td>
                        <a href="{{ route('admin.guru.edit', $g->id) }}" class="btn btn-warning btn-sm">
                            <i class="fa fa-edit"></i>
                        </a>

                        <form action="{{ route('admin.guru.delete', $g->id) }}" method="POST" class="d-inline"
                              onsubmit="return confirm('Hapus guru ini?')">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-danger btn-sm">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
