@extends('layouts.admin')

@section('title', 'Tambah Inventaris')

@section('content')
<h4 class="fw-bold mb-3">Tambah Inventaris</h4>

<div class="card shadow-sm">
    <div class="card-body">

        <form action="{{ route('admin.inventaris.store') }}" method="POST">
            @csrf

            <div class="row">

                <div class="col-md-6 mb-3">
                    <label>Kode Barang</label>
                    <input type="text" name="kode_barang" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Nama Barang</label>
                    <input type="text" name="nama_barang" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Kategori</label>
                    <select name="id_kategori" class="form-control">
                        <option value="">-- Tidak Ada Kategori --</option>
                        @foreach ($kategori as $k)
                        <option value="{{ $k->id }}">{{ $k->nama }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Jumlah</label>
                    <input type="number" name="jumlah" class="form-control" required value="1">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Kondisi</label>
                    <input type="text" name="kondisi" class="form-control" value="Baik">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Lokasi</label>
                    <input type="text" name="lokasi" class="form-control" value="Laboratorium TKJT">
                </div>

                <div class="col-12 mb-3">
                    <label>Keterangan</label>
                    <textarea name="keterangan" class="form-control" rows="3"></textarea>
                </div>

            </div>

            <button class="btn btn-primary">
                <i class="fa fa-save me-1"></i> Simpan
            </button>

            <a href="{{ route('admin.inventaris.index') }}" class="btn btn-secondary">Kembali</a>

        </form>

    </div>
</div>
@endsection
