@extends('layouts.admin')

@section('title', 'Data Inventaris')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold">Data Inventaris</h4>
    <a href="{{ route('admin.inventaris.create') }}" class="btn btn-primary">
        <i class="fa fa-plus me-1"></i> Tambah Inventaris
    </a>
</div>

<div class="card shadow-sm">
    <div class="card-body">

        <table id="datatable" class="table table-striped table-bordered align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Kode</th>
                    <th>Nama Barang</th>
                    <th>Kategori</th>
                    <th>Jumlah</th>
                    <th>Kondisi</th>
                    <th>Lokasi</th>
                    <th width="130">Aksi</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($inventaris as $i)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $i->kode_barang }}</td>
                    <td>{{ $i->nama_barang }}</td>
                    <td>{{ $i->kategori->nama ?? '-' }}</td>
                    <td>{{ $i->jumlah }}</td>
                    <td>{{ $i->kondisi }}</td>
                    <td>{{ $i->lokasi }}</td>

                    <td>
                        <a href="{{ route('admin.inventaris.edit', $i->id) }}" class="btn btn-warning btn-sm">
                            <i class="fa fa-edit"></i>
                        </a>

                        <form action="{{ route('admin.inventaris.delete', $i->id) }}"
                              method="POST"
                              class="d-inline"
                              onsubmit="return confirm('Hapus data ini?')">
                            @csrf
                            @method('DELETE')

                            <button class="btn btn-danger btn-sm">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

    </div>
</div>
@endsection
