@extends('layouts.admin')

@section('title', 'Daftar Peminjaman Alat')

@section('content')
<div class="container-fluid py-4">
    <h3 class="mb-4">Daftar Peminjaman Alat</h3>

    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-striped table-bordered" id="datatable">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Kode Peminjaman</th>
                        <th>Peminjam</th>
                        <th>Status</th>
                        <th>Tanggal Pinjam</th>
                        <th>Tanggal Kembali</th>
                        <th>Total Barang</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($peminjaman as $pm)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $pm->kode_peminjaman }}</td>
                        <td>
                            @if($pm->peminjam_role === 'siswa')
                                {{ $pm->siswa?->nama ?? '-' }}
                            @else
                                {{ $pm->guru?->nama ?? '-' }}
                            @endif
                        </td>
                        <td>
                            <span class="badge 
                                {{ $pm->status == 'dipinjam' ? 'bg-warning' : ($pm->status == 'dikembalikan' ? 'bg-success' : 'bg-secondary') }}">
                                {{ ucfirst($pm->status) }}
                            </span>
                        </td>
                        <td>{{ $pm->tanggal_pinjam }}</td>
                        <td>{{ $pm->tanggal_kembali }}</td>
                        <td>{{ $pm->total_barang }}</td>
                        <td>
                            <a href="{{ route('admin.peminjaman.detail', $pm->id) }}" class="btn btn-sm btn-primary">
                                <i class="fa fa-eye"></i> Detail
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('#datatable').DataTable({
            "order": [[ 0, "desc" ]]
        });
    });
</script>
@endpush
@endsection
