@extends('layouts.guru')

@section('title', 'Peminjaman')

@section('content')
<h3 class="mb-3">Daftar Peminjaman</h3>

<table id="peminjamanTable" class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>Kode Peminjaman</th>
            <th>Tanggal Pinjam</th>
            <th>Tanggal Kembali</th>
            <th>Status</th>
            <th>Total Barang</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        @foreach($peminjaman as $p)
        <tr>
            <td>{{ $p->kode_peminjaman }}</td>
            <td>{{ $p->tanggal_pinjam }}</td>
            <td>{{ $p->tanggal_kembali }}</td>
            <td>{{ $p->status }}</td>
            <td>{{ $p->total_barang }}</td>
            <td>
                <a href="{{ route('guru.peminjaman.detail', $p->id) }}" class="btn btn-info btn-sm"><i class="fa-solid fa-eye"></i> Detail</a>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#peminjamanTable').DataTable();
});
</script>
@endpush
