@extends('layouts.guru')

@section('title', 'Penggunaan Bahan')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <h3>Daftar Penggunaan Bahan</h3>
    <a href="{{ route('guru.penggunaan_bahan.create') }}" class="btn btn-primary"><i class="fa-solid fa-plus"></i> Tambah Penggunaan</a>
</div>

<table id="penggunaanTable" class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>Kode Penggunaan</th>
            <th>Siswa</th>
            <th>Tanggal</th>
            <th>Keterangan</th>
        </tr>
    </thead>
    <tbody>
        @foreach($penggunaan as $p)
        <tr>
            <td>{{ $p->kode_penggunaan }}</td>
            <td>{{ $p->siswa->nama ?? '-' }}</td>
            <td>{{ $p->tanggal }}</td>
            <td>{{ $p->keterangan }}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#penggunaanTable').DataTable();
});
</script>
@endpush
