<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Guru - @yield('title', 'Dashboard')</title>

  <!-- Bootstrap & Font Awesome -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">

  <style>
    body {
      background: #f3f4f6;
      font-family: system-ui, sans-serif;
    }
    .navbar {
      background: white;
      box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    }
    .content {
      padding: 20px;
    }
    .card {
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.05);
      border: none;
    }
    .btn {
      border-radius: 8px;
    }
  </style>
  
  @stack('styles')
</head>
<body>
  <!-- Navbar -->
  <nav class="navbar navbar-expand-lg">
    <div class="container-fluid">
      <button class="btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebar">
        <i class="fa-solid fa-bars"></i>
      </button>
      <span class="navbar-brand">Guru - @yield('title', 'Dashboard')</span>
      <div>
        <form method="POST" action="{{ route('logout') }}" class="d-inline">
          @csrf
          <button class="btn btn-outline-danger btn-sm">
            <i class="fa-solid fa-right-from-bracket"></i> Logout
          </button>
        </form>
      </div>
    </div>
  </nav>

  <!-- Content -->
  <main class="content">
    @if(session('success'))
      <div class="alert alert-success alert-dismissible fade show">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    @endif
    @if(session('error'))
      <div class="alert alert-danger alert-dismissible fade show">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    @endif
    
    @yield('content')
  </main>

  <!-- Sidebar Offcanvas -->
  <div class="offcanvas offcanvas-start" id="sidebar">
    <div class="offcanvas-header">
      <h5 class="offcanvas-title"><i class="fa-solid fa-chalkboard-user"></i> Menu Guru</h5>
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body">
      <div class="d-grid gap-2">
        <a class="btn btn-outline-primary text-start" href="{{ route('guru.dashboard') }}">
          <i class="fa-solid fa-gauge-high"></i> Dashboard
        </a>
        <a class="btn btn-outline-primary text-start" href="{{ route('guru.inventaris.index') }}">
          <i class="fa-solid fa-boxes-stacked"></i> Inventaris
        </a>
        <a class="btn btn-outline-primary text-start" href="{{ route('guru.peminjaman.index') }}">
          <i class="fa-solid fa-handshake"></i> Peminjaman
        </a>
        <a class="btn btn-outline-primary text-start" href="{{ route('guru.penggunaan_bahan.index') }}">
          <i class="fa-solid fa-flask-vial"></i> Penggunaan Bahan
        </a>
        <a class="btn btn-outline-primary text-start" href="{{ route('guru.profil') }}">
          <i class="fa-solid fa-user"></i> Profil
        </a>
        <form method="POST" action="{{ route('logout') }}" class="mt-3">
          @csrf
          <button class="btn btn-danger w-100">
            <i class="fa-solid fa-right-from-bracket"></i> Logout
          </button>
        </form>
      </div>
    </div>
  </div>

  <!-- Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    setTimeout(() => {
      document.querySelectorAll('.alert').forEach(alert => {
        alert.classList.remove('show');
      });
    }, 5000);
  </script>

  @stack('scripts')
</body>
</html>