@extends('layouts.siswa')

@section('title', 'Peminjaman Alat')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="fa-solid fa-box"></i> Daftar Peminjaman</h3>
        <a href="{{ route('siswa.peminjaman.create') }}" class="btn btn-success">
            <i class="fa-solid fa-plus"></i> Tambah Peminjaman
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <table class="table table-striped datatable">
                <thead>
                    <tr>
                        <th>Kode</th>
                        <th>Tanggal Pinjam</th>
                        <th>Tanggal Kembali</th>
                        <th>Status</th>
                        <th>Total Barang</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($peminjaman as $pinjam)
                    <tr>
                        <td>{{ $pinjam->kode_peminjaman }}</td>
                        <td>{{ $pinjam->tanggal_pinjam }}</td>
                        <td>{{ $pinjam->tanggal_kembali }}</td>
                        <td>{{ ucfirst($pinjam->status) }}</td>
                        <td>{{ $pinjam->total_barang }}</td>
                        <td>
                            <a href="{{ route('siswa.peminjaman.detail', $pinjam->id) }}" class="btn btn-primary btn-sm">
                                <i class="fa-solid fa-eye"></i> Detail
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
