

<?php $__env->startSection('title', 'Daftar Aturan Peminjaman'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <h3 class="mb-4">Daftar Aturan Peminjaman</h3>

    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-striped table-bordered" id="datatable">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Nama Aturan</th>
                        <th>Deskripsi</th>
                        <th>Maksimal Hari</th>
                        <th>Denda/Hari</th>
                        <th>Perlu Persetujuan Guru</th>
                        <th>Aktif</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $aturan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($a->nama); ?></td>
                        <td><?php echo e($a->deskripsi); ?></td>
                        <td><?php echo e($a->maksimal_hari); ?></td>
                        <td><?php echo e($a->denda_per_hari); ?></td>
                        <td>
                            <span class="badge <?php echo e($a->perlu_persetujuan_guru ? 'bg-success' : 'bg-secondary'); ?>">
                                <?php echo e($a->perlu_persetujuan_guru ? 'Ya' : 'Tidak'); ?>

                            </span>
                        </td>
                        <td>
                            <span class="badge <?php echo e($a->aktif ? 'bg-success' : 'bg-danger'); ?>">
                                <?php echo e($a->aktif ? 'Aktif' : 'Nonaktif'); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.aturan.edit', $a->id)); ?>" class="btn btn-sm btn-primary">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#datatable').DataTable({
            "order": [[ 0, "desc" ]]
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/admin/aturan/index.blade.php ENDPATH**/ ?>