

<?php $__env->startSection('title', 'Tambah Peminjaman'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <h3 class="mb-4"><i class="fa-solid fa-plus"></i> Tambah Peminjaman</h3>

    <div class="card p-3">
        <form action="<?php echo e(route('siswa.peminjaman.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
                <label>Tanggal Pinjam</label>
                <input type="date" name="tanggal_pinjam" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Tanggal Kembali</label>
                <input type="date" name="tanggal_kembali" class="form-control" required>
            </div>

            <hr>
            <h5>Daftar Barang</h5>
            <div id="barang-list">
                <div class="row mb-2 align-items-center barang-item">
                    <div class="col-md-6">
                        <select name="barang_id[]" class="form-select" required>
                            <option value="">-- Pilih Barang --</option>
                            <?php $__currentLoopData = $barang; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($b->id); ?>"><?php echo e($b->nama); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <input type="number" name="jumlah[]" class="form-control" min="1" placeholder="Jumlah" required>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-danger btn-sm remove-barang">
                            <i class="fa-solid fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>

            <button type="button" class="btn btn-secondary btn-sm mb-3" id="add-barang">
                <i class="fa-solid fa-plus"></i> Tambah Barang
            </button>

            <div>
                <button type="submit" class="btn btn-success"><i class="fa-solid fa-save"></i> Simpan Peminjaman</button>
                <a href="<?php echo e(route('siswa.peminjaman.index')); ?>" class="btn btn-secondary">Batal</a>
            </div>
        </form>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const barangList = document.getElementById('barang-list');
    const addBtn = document.getElementById('add-barang');

    addBtn.addEventListener('click', () => {
        const newItem = barangList.querySelector('.barang-item').cloneNode(true);
        newItem.querySelector('select').value = '';
        newItem.querySelector('input').value = '';
        barangList.appendChild(newItem);
    });

    barangList.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-barang') || e.target.closest('.remove-barang')) {
            const item = e.target.closest('.barang-item');
            if (barangList.querySelectorAll('.barang-item').length > 1) {
                item.remove();
            }
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.siswa', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/siswa/peminjaman/create.blade.php ENDPATH**/ ?>