

<?php $__env->startSection('title', 'Koneksi API Sarpras'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <h3 class="mb-4">Koneksi API Sarpras</h3>

    <div class="mb-3">
        <form action="<?php echo e(route('admin.api.sarpras.sync')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <button type="submit" class="btn btn-success">
                <i class="fa fa-sync"></i> Sync Sekarang
            </button>
        </form>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <table class="table table-bordered table-striped" id="datatable">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Nama Aplikasi</th>
                        <th>Endpoint URL</th>
                        <th>Status</th>
                        <th>Last Sync</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $koneksi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($k->nama_aplikasi); ?></td>
                        <td><?php echo e($k->endpoint_url); ?></td>
                        <td>
                            <span class="badge <?php echo e($k->aktif ? 'bg-success' : 'bg-secondary'); ?>">
                                <?php echo e($k->aktif ? 'Aktif' : 'Nonaktif'); ?>

                            </span>
                        </td>
                        <td><?php echo e($k->last_sync ? $k->last_sync->format('d-m-Y H:i') : '-'); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#datatable').DataTable({
            "order": [[ 0, "desc" ]]
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/admin/api_sarpras/koneksi_index.blade.php ENDPATH**/ ?>