

<?php $__env->startSection('title', 'Peminjaman'); ?>

<?php $__env->startSection('content'); ?>
<h3 class="mb-3">Daftar Peminjaman</h3>

<table id="peminjamanTable" class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>Kode Peminjaman</th>
            <th>Tanggal Pinjam</th>
            <th>Tanggal Kembali</th>
            <th>Status</th>
            <th>Total Barang</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $peminjaman; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($p->kode_peminjaman); ?></td>
            <td><?php echo e($p->tanggal_pinjam); ?></td>
            <td><?php echo e($p->tanggal_kembali); ?></td>
            <td><?php echo e($p->status); ?></td>
            <td><?php echo e($p->total_barang); ?></td>
            <td>
                <a href="<?php echo e(route('guru.peminjaman.detail', $p->id)); ?>" class="btn btn-info btn-sm"><i class="fa-solid fa-eye"></i> Detail</a>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    $('#peminjamanTable').DataTable();
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.guru', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/guru/peminjaman/index.blade.php ENDPATH**/ ?>