

<?php $__env->startSection('title', 'Data Guru'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold">Data Guru</h4>
    <a href="<?php echo e(route('admin.guru.create')); ?>" class="btn btn-primary">
        <i class="fa fa-plus me-1"></i> Tambah Guru
    </a>
</div>

<div class="card shadow-sm">
    <div class="card-body">
        <table id="datatable" class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>NIP</th>
                    <th>Nama</th>
                    <th>Email</th>
                    <th>Telepon</th>
                    <th>Jabatan</th>
                    <th>Harus Setujui Sarpras</th>
                    <th width="150">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $guru; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($g->nip); ?></td>
                    <td><?php echo e($g->nama); ?></td>
                    <td><?php echo e($g->email); ?></td>
                    <td><?php echo e($g->telepon); ?></td>
                    <td><?php echo e($g->jabatan); ?></td>
                    <td>
                        <?php if($g->harus_setujui_sarpras): ?>
                            <span class="badge bg-success">Ya</span>
                        <?php else: ?>
                            <span class="badge bg-secondary">Tidak</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo e(route('admin.guru.edit', $g->id)); ?>" class="btn btn-warning btn-sm">
                            <i class="fa fa-edit"></i>
                        </a>

                        <form action="<?php echo e(route('admin.guru.delete', $g->id)); ?>" method="POST" class="d-inline"
                              onsubmit="return confirm('Hapus guru ini?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-danger btn-sm">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/admin/guru/index.blade.php ENDPATH**/ ?>