

<?php $__env->startSection('title', 'Peminjaman Alat'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="fa-solid fa-box"></i> Daftar Peminjaman</h3>
        <a href="<?php echo e(route('siswa.peminjaman.create')); ?>" class="btn btn-success">
            <i class="fa-solid fa-plus"></i> Tambah Peminjaman
        </a>
    </div>

    <div class="card">
        <div class="card-body">
            <table class="table table-striped datatable">
                <thead>
                    <tr>
                        <th>Kode</th>
                        <th>Tanggal Pinjam</th>
                        <th>Tanggal Kembali</th>
                        <th>Status</th>
                        <th>Total Barang</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $peminjaman; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pinjam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($pinjam->kode_peminjaman); ?></td>
                        <td><?php echo e($pinjam->tanggal_pinjam); ?></td>
                        <td><?php echo e($pinjam->tanggal_kembali); ?></td>
                        <td><?php echo e(ucfirst($pinjam->status)); ?></td>
                        <td><?php echo e($pinjam->total_barang); ?></td>
                        <td>
                            <a href="<?php echo e(route('siswa.peminjaman.detail', $pinjam->id)); ?>" class="btn btn-primary btn-sm">
                                <i class="fa-solid fa-eye"></i> Detail
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.siswa', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\inventaris_tkjt\resources\views/siswa/peminjaman/index.blade.php ENDPATH**/ ?>