<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Guru;

class AdminGuruController extends Controller
{
    public function index()
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $guru = Guru::orderBy('id','desc')->get();
        return view('admin.guru.index', compact('guru'));
    }

    public function create()
    {
        if (!session('admin_id')) return redirect()->route('login');
        return view('admin.guru.create');
    }

    public function store(Request $r)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        Guru::create([
            'nip' => $r->input('nip'),
            'nama' => $r->input('nama'),
            'email' => $r->input('email'),
            'password' => $r->input('password'),
            'telepon' => $r->input('telepon'),
            'jabatan' => $r->input('jabatan') ?? 'Guru',
            'harus_setujui_sarpras' => $r->input('harus_setujui_sarpras') ? 1 : 0
        ]);

        return redirect()->route('admin.guru.index')->with('success', 'Guru berhasil ditambahkan');
    }

    public function edit($id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $row = Guru::findOrFail($id);
        return view('admin.guru.edit', compact('row'));
    }

    public function update(Request $r, $id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        $g = Guru::findOrFail($id);
        $g->update([
            'nip' => $r->input('nip'),
            'nama' => $r->input('nama'),
            'email' => $r->input('email'),
            'password' => $r->input('password') ?: $g->password,
            'telepon' => $r->input('telepon'),
            'jabatan' => $r->input('jabatan') ?? $g->jabatan,
            'harus_setujui_sarpras' => $r->input('harus_setujui_sarpras') ? 1 : 0
        ]);

        return redirect()->route('admin.guru.index')->with('success', 'Guru berhasil diupdate');
    }

    public function destroy($id)
    {
        if (!session('admin_id')) return redirect()->route('login');
        
        Guru::findOrFail($id)->delete();
        return back()->with('success', 'Guru berhasil dihapus');
    }
}