<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Models\Siswa;
use App\Models\Guru;
use App\Models\Inventaris;
use App\Models\PeminjamanAlat;
use App\Models\BahanPraktik;

class DashboardController extends Controller
{
    public function index()
    {
        // ✅ TAMBAH: Session check
        if (!session('admin_id')) return redirect()->route('login');
        
        // Summary sederhana
        $totalSiswa = Siswa::count();
        $totalGuru = Guru::count();
        $totalInventaris = Inventaris::count();
        $totalPeminjamanPending = PeminjamanAlat::where('status', 'pending')->count();
        $totalBahan = BahanPraktik::count();

        return view('admin.dashboard', compact(
            'totalSiswa',
            'totalGuru',
            'totalInventaris',
            'totalPeminjamanPending',
            'totalBahan'
        ));
    }
}