@extends('layouts.admin')
@section('title', 'Data Guru')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h3 class="fw-bold">Data Guru</h3>
    <a href="{{ route('admin.guru.create') }}" class="btn btn-primary rounded-3 px-4">
        <i class="fa fa-plus me-2"></i> Tambah Guru
    </a>
</div>

<div class="card shadow-sm rounded-4 p-3">
    <div class="table-responsive">
        <table class="table table-striped table-bordered align-middle" id="datatable">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>NIP</th>
                    <th>Nama</th>
                    <th>Email</th>
                    <th>Telepon</th>
                    <th>Jabatan</th>
                    <th>Harus Setujui Sarpras</th>
                    <th width="130px">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($guru as $g)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $g->nip }}</td>
                    <td>{{ $g->nama }}</td>
                    <td>{{ $g->email }}</td>
                    <td>{{ $g->telepon }}</td>
                    <td>{{ $g->jabatan }}</td>
                    <td>
                        <span class="badge {{ $g->harus_setujui_sarpras ? 'bg-success' : 'bg-secondary' }}">
                            {{ $g->harus_setujui_sarpras ? 'Ya' : 'Tidak' }}
                        </span>
                    </td>
                    <td>
                        <a href="{{ route('admin.guru.edit', $g->id) }}" class="btn btn-sm btn-warning rounded-3">
                            <i class="fa fa-edit"></i>
                        </a>
                        <form action="{{ route('admin.guru.delete', $g->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger rounded-3" onclick="return confirm('Hapus guru?')">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function(){
    $('#datatable').DataTable({"order":[[0,"desc"]]});
});
</script>
@endpush
@endsection
