@extends('layouts.admin')

@section('title', 'Detail Peminjaman Alat')

@section('content')
<div class="container-fluid py-4">
    <h3 class="mb-4">Detail Peminjaman - {{ $pm->kode_peminjaman }}</h3>

    <div class="card mb-4 shadow-sm">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Peminjam:</strong> 
                        @if($pm->peminjam_role === 'siswa')
                            {{ $pm->siswa?->nama ?? '-' }}
                        @else
                            {{ $pm->guru?->nama ?? '-' }}
                        @endif
                    </p>
                    <p><strong>Status:</strong> {{ ucfirst($pm->status) }}</p>
                    <p><strong>Tanggal Pinjam:</strong> {{ $pm->tanggal_pinjam }}</p>
                    <p><strong>Tanggal Kembali:</strong> {{ $pm->tanggal_kembali }}</p>
                </div>
                <div class="col-md-6">
                    <p><strong>Total Barang:</strong> {{ $pm->total_barang }}</p>
                    <p><strong>Denda:</strong> {{ $pm->denda ?? 0 }}</p>
                    <p><strong>Alasan:</strong> {{ $pm->alasan ?? '-' }}</p>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="mb-3">Daftar Barang</h5>
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Nama Barang</th>
                        <th>Jumlah</th>
                        <th>Kondisi Pinjam</th>
                        <th>Kondisi Kembali</th>
                        <th>Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($details as $det)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $det->barang?->nama ?? '-' }}</td>
                        <td>{{ $det->jumlah }}</td>
                        <td>{{ $det->kondisi_pinjam }}</td>
                        <td>{{ $det->kondisi_kembali ?? '-' }}</td>
                        <td>{{ $det->keterangan ?? '-' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <a href="{{ route('admin.peminjaman.index') }}" class="btn btn-secondary mt-3">
        <i class="fa fa-arrow-left"></i> Kembali
    </a>
</div>
@endsection
