@extends('layouts.guru')
@section('title','Tambah Penggunaan')

@section('content')
<div class="card shadow-sm">
    <div class="card-body">
        <form method="POST" action="{{ route('guru.penggunaan_bahan.store') }}">
        @csrf

        <div class="row g-3 mb-3">
            <div class="col-md-6">
                <label class="form-label">Siswa</label>
                <select name="id_siswa" class="form-select" required>
                    <option value="">-- Pilih Siswa --</option>
                    @foreach($siswa as $s)
                        <option value="{{ $s->id }}">{{ $s->nama }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">Tanggal</label>
                <input type="date" name="tanggal" class="form-control" required>
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label">Keterangan</label>
            <input type="text" name="keterangan" class="form-control">
        </div>

        <h6 class="mb-2">Daftar Bahan</h6>
        <div id="bahanBox"></div>

        <button type="button" id="add" class="btn btn-outline-secondary btn-sm mb-3">
            + Tambah Bahan
        </button>

        <div class="d-grid">
            <button class="btn btn-success">Simpan Penggunaan</button>
        </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
let i = 0;
function addBahan(){
    document.getElementById('bahanBox').insertAdjacentHTML('beforeend',`
    <div class="row g-2 mb-2">
        <div class="col-12 col-md-4">
            <select name="bahan[${i}][id_bahan]" class="form-select" required>
                @foreach($bahan as $b)
                <option value="{{ $b->id }}">{{ $b->nama }} (stok: {{ $b->stok }})</option>
                @endforeach
            </select>
        </div>
        <div class="col-4 col-md-2">
            <input type="number" name="bahan[${i}][jumlah]" class="form-control" min="1" required>
        </div>
        <div class="col-4 col-md-2">
            <input type="text" name="bahan[${i}][satuan]" class="form-control" value="pcs">
        </div>
        <div class="col-4 col-md-4">
            <input type="text" name="bahan[${i}][keterangan]" class="form-control" placeholder="Opsional">
        </div>
    </div>
    `);
    i++;
}
document.getElementById('add').onclick = addBahan;
addBahan();
</script>
@endpush
