@extends('layouts.siswa')

@section('title', 'Profil Siswa')

@section('content')
<div class="container-fluid">
    <h3 class="mb-4"><i class="fa-solid fa-user"></i> Profil Siswa</h3>

    <div class="card p-4">
        <form action="{{ route('siswa.profil.update') }}" method="POST">
            @csrf
            @method('POST') {{-- karena update pakai route GET, bisa POST di sini tanpa middleware auth --}}

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Nama Lengkap</label>
                    <input type="text" name="nama" class="form-control" value="{{ $siswa->nama }}" required>
                </div>
                <div class="col-md-6">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" value="{{ $siswa->email }}" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label>Kelas</label>
                    <input type="text" name="kelas" class="form-control" value="{{ $siswa->kelas }}">
                </div>
                <div class="col-md-4">
                    <label>Jurusan</label>
                    <input type="text" name="jurusan" class="form-control" value="{{ $siswa->jurusan }}">
                </div>
                <div class="col-md-4">
                    <label>Telepon</label>
                    <input type="text" name="telepon" class="form-control" value="{{ $siswa->telepon }}">
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Password</label>
                    <input type="text" name="password" class="form-control" value="{{ $siswa->password }}" required>
                </div>
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success">
                    <i class="fa-solid fa-save"></i> Simpan Perubahan
                </button>
                <a href="{{ route('siswa.dashboard') }}" class="btn btn-secondary">
                    <i class="fa-solid fa-arrow-left"></i> Kembali
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
